/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.render;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.RenderUtil;
import net.tslat.aoa3.utils.StringUtil;

public class XpParticlesRenderer {
    private static final ConcurrentHashMap<Enums.Skills, CopyOnWriteArrayList<XPParticle>> particlesMap = new ConcurrentHashMap(15);
    private static final ResourceLocation skillsTextures = new ResourceLocation("aoa3", "textures/gui/maingui/skills.png");
    private static long lastPacketReceivedTime = 0L;
    private static XPParticle lastParticleReceived = null;
    private static Enums.Skills lastParticleSkill = null;

    public static void addXpParticle(Enums.Skills skill, float xp, boolean isLevelUp) {
        XPParticle particle;
        if (!particlesMap.containsKey((Object)skill)) {
            particlesMap.put(skill, new CopyOnWriteArrayList());
        }
        if (lastParticleSkill == skill && System.currentTimeMillis() <= lastPacketReceivedTime + 10L && lastParticleReceived != null) {
            lastParticleReceived.modifyXp(xp, isLevelUp);
            if (XpParticlesRenderer.lastParticleReceived.levelUp) {
                CopyOnWriteArrayList<XPParticle> array = particlesMap.get((Object)skill);
                if (array.size() > 0) {
                    array.remove(array.size() - 1);
                }
                array.add(0, lastParticleReceived);
            }
            return;
        }
        if (isLevelUp) {
            particle = new XPParticle(xp, true);
            particlesMap.get((Object)skill).add(0, particle);
        } else {
            particle = new XPParticle(xp, false);
            particlesMap.get((Object)skill).add(particle);
        }
        lastParticleReceived = particle;
        lastPacketReceivedTime = System.currentTimeMillis();
        lastParticleSkill = skill;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END || particlesMap.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        if (ConfigurationUtil.MainConfig.showXpParticles) {
            if (mc.field_71462_r == null && !mc.field_71474_y.field_74319_N) {
                GlStateManager.func_179097_i();
                GlStateManager.func_179141_d();
                long currentTime = System.currentTimeMillis();
                Iterator<Map.Entry<Enums.Skills, CopyOnWriteArrayList<XPParticle>>> mapIterator = particlesMap.entrySet().iterator();
                int skillCount = particlesMap.size();
                int scrollHeight = (int)((float)res.func_78328_b() / 3.0f);
                int skillNum = 0;
                float rowBasedScale = (int)(1.0f + (float)(skillCount - 1) / 5.0f);
                float renderSize = 25.0f / (1.0f + (rowBasedScale - 1.0f) * 0.5f);
                double skillIconsX = (res.func_78327_c() - (double)(renderSize * (1.0f + (float)(Math.min(skillCount, 5) - 1) * 0.5f))) / 2.0;
                double skillIconsY = 2.0;
                while (mapIterator.hasNext()) {
                    Map.Entry<Enums.Skills, CopyOnWriteArrayList<XPParticle>> particleEntry = mapIterator.next();
                    Enums.Skills skill = particleEntry.getKey();
                    CopyOnWriteArrayList<XPParticle> particleArray = particleEntry.getValue();
                    if (particleArray.isEmpty()) {
                        mapIterator.remove();
                        continue;
                    }
                    boolean isLevelUp = particleArray.get((int)0).levelUp;
                    ArrayList<XPParticle> removalList = null;
                    for (XPParticle particle2 : particleArray) {
                        float particleLifespan = 1.0f - (float)(currentTime - particle2.creationTime) / 1500.0f;
                        if ((double)particleLifespan >= 0.1) {
                            RenderUtil.drawCenteredScaledString(mc.field_71466_p, particle2.xpString, (int)(res.func_78327_c() / 2.0), (int)((float)scrollHeight * particleLifespan), 0.5f, 0xFFFFFF | (int)MathHelper.func_76131_a((float)(255.0f * particleLifespan), (float)1.0f, (float)255.0f) << 24, RenderUtil.StringRenderType.NORMAL);
                        }
                        if (particle2.creationTime > currentTime - 1800L) continue;
                        if (removalList == null) {
                            removalList = new ArrayList<XPParticle>();
                        }
                        removalList.add(particle2);
                    }
                    int skillUvX = 0;
                    int skillUvY = isLevelUp ? 50 : 0;
                    switch (skill) {
                        case ALCHEMY: {
                            break;
                        }
                        case ANIMA: {
                            skillUvX = 50;
                            break;
                        }
                        case AUGURY: {
                            skillUvX = 100;
                            break;
                        }
                        case BUTCHERY: {
                            skillUvX = 150;
                            break;
                        }
                        case CREATION: {
                            skillUvX = 200;
                            break;
                        }
                        case ENGINEERING: {
                            skillUvX = 250;
                            break;
                        }
                        case EXPEDITION: {
                            skillUvX = 300;
                            break;
                        }
                        case EXTRACTION: {
                            skillUvX = 350;
                            break;
                        }
                        case FORAGING: {
                            skillUvX = 400;
                            break;
                        }
                        case HAULING: {
                            skillUvY += 100;
                            break;
                        }
                        case HUNTER: {
                            skillUvX = 50;
                            skillUvY += 100;
                            break;
                        }
                        case INFUSION: {
                            skillUvX = 100;
                            skillUvY += 100;
                            break;
                        }
                        case INNERVATION: {
                            skillUvX = 150;
                            skillUvY += 100;
                            break;
                        }
                        case LOGGING: {
                            skillUvX = 200;
                            skillUvY += 100;
                            break;
                        }
                        case RUNATION: {
                            skillUvX = 250;
                            skillUvY += 100;
                        }
                    }
                    double newX = skillIconsX + (double)((float)(skillNum % 5) * renderSize * 0.5f);
                    double newY = 2.0 + (double)((float)(skillNum / 5) * renderSize * 0.5f);
                    mc.func_110434_K().func_110577_a(skillsTextures);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderUtil.drawScaledCustomSizeModalRect(newX, newY, skillUvX, skillUvY, 50.0f, 50.0f, renderSize, renderSize, 450.0f, 240.0f);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (isLevelUp) {
                        String lvl = String.valueOf(AdventGuiTabPlayer.getSkillLevel(skill));
                        float stringScale = Math.min(1.4f, 16.8f / (float)mc.field_71466_p.func_78256_a(lvl)) / rowBasedScale;
                        RenderUtil.drawCenteredScaledString(mc.field_71466_p, lvl, (int)(newX + (double)((renderSize + 2.0f) / 2.0f)), (int)(newY + (double)(renderSize / 2.0f) - (double)((float)mc.field_71466_p.field_78288_b / 3.0f * stringScale)), stringScale, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
                    }
                    if (removalList != null) {
                        particleArray.removeAll(removalList);
                    }
                    if (particleArray.isEmpty()) {
                        mapIterator.remove();
                    }
                    ++skillNum;
                }
                GlStateManager.func_179126_j();
                GlStateManager.func_179118_c();
            } else if (!particlesMap.isEmpty()) {
                Iterator<Map.Entry<Enums.Skills, CopyOnWriteArrayList<XPParticle>>> mapIterator = particlesMap.entrySet().iterator();
                long cutoffTime = System.currentTimeMillis() - 1800L;
                while (mapIterator.hasNext()) {
                    CopyOnWriteArrayList<XPParticle> particleArray = mapIterator.next().getValue();
                    particleArray.removeIf(particle -> particle.creationTime <= cutoffTime);
                    if (!particleArray.isEmpty()) continue;
                    mapIterator.remove();
                }
            }
        } else if (!particlesMap.isEmpty()) {
            particlesMap.clear();
        }
    }

    private static String getAprilFoolsXpString() {
        switch (AdventOfAscension.rand.nextInt(9)) {
            case 0: {
                return "Nice!";
            }
            case 1: {
                return "69xp";
            }
            case 2: {
                return "420xp";
            }
            case 3: {
                return "-1xp";
            }
            case 4: {
                return "422180734982xp";
            }
            case 5: {
                return "Xp Get!";
            }
            case 6: {
                return "GAINSSS";
            }
            case 7: {
                return "5xp maybe?";
            }
        }
        return "\u00e2\u0152\u02c6(\u00e2\u0152\u02c6A1*50^1.3\u00e2\u0152\u2030/8+800)/46*37\u00e2\u0152\u2030+6xp";
    }

    static class XPParticle {
        boolean levelUp;
        float xp;
        String xpString;
        protected long creationTime = System.currentTimeMillis();

        XPParticle(float xp, boolean isLevelUp) {
            this.levelUp = isLevelUp;
            this.xp = xp;
            this.xpString = AdventOfAscension.instance().holiday == AdventOfAscension.Holiday.APRIL_FOOLS ? XpParticlesRenderer.getAprilFoolsXpString() : "+" + StringUtil.floorAndAppendSuffix(xp, false);
        }

        protected void modifyXp(float additionalXp, boolean isLevelUp) {
            this.levelUp = this.levelUp || isLevelUp;
            this.xp += additionalXp;
            this.xpString = AdventOfAscension.instance().holiday == AdventOfAscension.Holiday.APRIL_FOOLS ? XpParticlesRenderer.getAprilFoolsXpString() : "+" + StringUtil.floorAndAppendSuffix(this.xp, false);
        }
    }
}

