/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.tslat.aoa3.client.event.KeyBinder;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.client.gui.render.ResourcesRenderer;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.RenderUtil;
import net.tslat.aoa3.utils.StringUtil;

public class SkillsRenderer {
    private final Minecraft mc = Minecraft.func_71410_x();
    private static final ResourceLocation skills = new ResourceLocation("aoa3:textures/gui/maingui/skills.png");

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderTick(TickEvent.RenderTickEvent ev) {
        if (this.mc.field_71462_r == null && !this.mc.field_71474_y.field_74319_N && !this.mc.field_71439_g.func_175149_v() && ConfigurationUtil.MainConfig.skillsEnabled) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179097_i();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179141_d();
            ScaledResolution res = new ScaledResolution(this.mc);
            int renderOffsetY = this.getPotionGuiRenderOffset();
            int renderOffsetX = (int)((float)(res.func_78326_a() - 200) / 0.5f);
            if (ConfigurationUtil.MainConfig.hudResourcesPosition == ResourcesRenderer.HudResourcesPosition.Top_Right) {
                if (!ConfigurationUtil.MainConfig.hudResourcesHorizontal) {
                    if (KeyBinder.statusResourceGui) {
                        renderOffsetX -= 50;
                    }
                } else if (KeyBinder.statusResourceGui) {
                    renderOffsetY += 50;
                } else if (KeyBinder.statusResourceGuiMessage) {
                    renderOffsetY += 15;
                }
            }
            this.renderSkills(renderOffsetX, renderOffsetY);
            GlStateManager.func_179118_c();
            GlStateManager.func_179121_F();
        }
    }

    private void renderSkills(int rootX, int rootY) {
        if (KeyBinder.statusSkillGui) {
            for (Enums.Skills skill : Enums.Skills.values()) {
                this.mc.func_110434_K().func_110577_a(skills);
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                int y = rootY + (int)Math.floor((float)skill.id / 8.0f) * 50;
                int x = rootX + 50 * (skill.id % 8);
                int progressBarPercent = AdventGuiTabPlayer.getPercentCompleteLevel(skill);
                int uvX = 0;
                int uvY = 0;
                int optionalUvX = -1;
                int optionalUvY = -1;
                int level = AdventGuiTabPlayer.getSkillLevel(skill);
                block0 : switch (skill) {
                    case ALCHEMY: {
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case ANIMA: {
                        uvX = 50;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case AUGURY: {
                        uvX = 100;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case BUTCHERY: {
                        uvX = 150;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case CREATION: {
                        uvX = 200;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case ENGINEERING: {
                        uvX = 250;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case EXPEDITION: {
                        uvX = 300;
                        uvY = level >= 100 ? 50 : 0;
                        switch (AdventGuiTabPlayer.getOptionalSkillData(Enums.Skills.EXPEDITION) % 4) {
                            case 1: {
                                optionalUvX = 300;
                                optionalUvY = 100;
                                break block0;
                            }
                            case 2: {
                                optionalUvX = 324;
                                optionalUvY = 100;
                                break block0;
                            }
                            case 3: {
                                optionalUvX = 348;
                                optionalUvY = 100;
                                break block0;
                            }
                        }
                        break;
                    }
                    case EXTRACTION: {
                        uvX = 350;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case FORAGING: {
                        uvX = 400;
                        uvY = level >= 100 ? 50 : 0;
                        break;
                    }
                    case HAULING: {
                        uvY = 100 + (level >= 100 ? 50 : 0);
                        break;
                    }
                    case HUNTER: {
                        uvX = 50;
                        uvY = 100 + (level >= 100 ? 50 : 0);
                        break;
                    }
                    case INFUSION: {
                        uvX = 100;
                        uvY = 100 + (level >= 100 ? 50 : 0);
                        break;
                    }
                    case INNERVATION: {
                        uvX = 150;
                        uvY = 100 + (level >= 100 ? 50 : 0);
                        break;
                    }
                    case LOGGING: {
                        uvX = 200;
                        uvY = 100 + (level >= 100 ? 50 : 0);
                        break;
                    }
                    case RUNATION: {
                        uvX = 250;
                        uvY = 100 + (level >= 100 ? 50 : 0);
                    }
                }
                RenderUtil.drawScaledCustomSizeModalRect(x, y, uvX, uvY, 50.0f, 50.0f, 50.0, 50.0, 450.0f, 240.0f);
                RenderUtil.drawScaledCustomSizeModalRect(x, y + 37, 0.0f, 200.0f, 100.0f, 20.0f, 50.0, 13.0, 450.0f, 240.0f);
                RenderUtil.drawScaledCustomSizeModalRect(x, y + 37, 0.0f, 220.0f, progressBarPercent, 20.0f, (float)progressBarPercent / 100.0f * 50.0f, 13.0, 450.0f, 240.0f);
                if (optionalUvX >= 0) {
                    RenderUtil.drawScaledCustomSizeModalRect(x, y, optionalUvX, optionalUvY, 24.0f, 24.0f, 24.0, 24.0, 450.0f, 240.0f);
                }
                RenderUtil.drawScaledString(this.mc.field_71466_p, String.valueOf(level), x + 45 - (int)((float)this.mc.field_71466_p.func_78256_a(String.valueOf(level)) * 1.5f), y, 1.5f, level < 100 ? 0xFFFFFF : 0xFFDF00, RenderUtil.StringRenderType.OUTLINED);
            }
        } else if (KeyBinder.statusSkillGuiMessage && KeyBinder.keySkillGui.func_151463_i() != 0) {
            RenderUtil.drawCenteredScaledString(this.mc.field_71466_p, StringUtil.getLocaleStringWithArguments("gui.skills.showTip", KeyBinder.keySkillGui.getDisplayName()), rootX + 228, rootY + 2, 1.5f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
        }
    }

    private int getPotionGuiRenderOffset() {
        if (this.mc.field_71439_g.func_70651_bq().isEmpty()) {
            return 0;
        }
        int effectRenderYOffset = 0;
        for (PotionEffect effect : this.mc.field_71439_g.func_70651_bq()) {
            if (effect.func_76459_b() <= 0 || !effect.func_188419_a().shouldRenderHUD(effect) || !effect.func_188418_e()) continue;
            if (effect.func_188419_a().func_76398_f()) {
                effectRenderYOffset = 100;
                break;
            }
            effectRenderYOffset = 50;
        }
        return effectRenderYOffset;
    }
}

