/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.tslat.aoa3.client.event.KeyBinder;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.RenderUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.skills.AuguryUtil;

public class ResourcesRenderer {
    private final Minecraft mc = Minecraft.func_71410_x();
    public static boolean revengeActive = false;
    private static final ResourceLocation resources = new ResourceLocation("aoa3:textures/gui/maingui/resources.png");

    public ResourcesRenderer() {
        revengeActive = false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderTick(TickEvent.RenderTickEvent ev) {
        if (this.mc.field_71462_r == null && !this.mc.field_71474_y.field_74319_N && !this.mc.field_71439_g.func_175149_v() && ConfigurationUtil.MainConfig.resourcesEnabled) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179097_i();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179141_d();
            ScaledResolution res = new ScaledResolution(this.mc);
            if (ConfigurationUtil.MainConfig.hudResourcesHorizontal) {
                switch (ConfigurationUtil.MainConfig.hudResourcesPosition) {
                    case Bottom_Right: {
                        this.renderHorizontalResources((int)((float)(res.func_78326_a() - 150) / 0.5f), (int)((float)(res.func_78328_b() - 25) / 0.5f));
                        break;
                    }
                    case Bottom_Left: {
                        this.renderHorizontalResources(0, (int)((float)(res.func_78328_b() - 25) / 0.5f));
                        break;
                    }
                    case Top_Left: {
                        this.renderHorizontalResources(0, 0);
                        break;
                    }
                    default: {
                        this.renderHorizontalResources((int)((float)(res.func_78326_a() - 150) / 0.5f), this.getPotionGuiRenderOffset());
                        break;
                    }
                }
            } else {
                switch (ConfigurationUtil.MainConfig.hudResourcesPosition) {
                    case Bottom_Right: {
                        this.renderVerticalResources((int)((float)(res.func_78326_a() - 25) / 0.5f), (int)((float)(res.func_78328_b() - 150) / 0.5f));
                        break;
                    }
                    case Bottom_Left: {
                        this.renderVerticalResources(0, (int)((float)(res.func_78328_b() - 150) / 0.5f));
                        break;
                    }
                    case Top_Left: {
                        this.renderVerticalResources(0, 0);
                        break;
                    }
                    default: {
                        this.renderVerticalResources((int)((float)(res.func_78326_a() - 25) / 0.5f), this.getPotionGuiRenderOffset());
                    }
                }
            }
            GlStateManager.func_179118_c();
            GlStateManager.func_179121_F();
        }
    }

    private int getPotionGuiRenderOffset() {
        if (this.mc.field_71439_g.func_70651_bq().isEmpty()) {
            return 0;
        }
        int effectRenderYOffset = 0;
        for (PotionEffect effect : this.mc.field_71439_g.func_70651_bq()) {
            if (effect.func_76459_b() <= 0 || !effect.func_188419_a().shouldRenderHUD(effect) || !effect.func_188418_e()) continue;
            if (effect.func_188419_a().func_76398_f()) {
                effectRenderYOffset = 100;
                break;
            }
            effectRenderYOffset = 50;
        }
        return effectRenderYOffset;
    }

    private void renderHorizontalResources(int rootX, int rootY) {
        if (KeyBinder.statusResourceGui) {
            this.mc.func_110434_K().func_110577_a(resources);
            if (revengeActive) {
                RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY, 100.0f, 90.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            }
            float percentComplete = (float)Math.floor(AdventGuiTabPlayer.resourceRage / 200.0f * 50.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 50, rootY, 0.0f, 190.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 50, rootY, AdventGuiTabPlayer.resourceRage >= 150.0f ? 50.0f : 0.0f, 240.0f, percentComplete, 50.0f, percentComplete, 50.0, 400.0f, 590.0f);
            percentComplete = (float)Math.floor((float)AdventGuiTabPlayer.tributeSelyan / 200.0f * 50.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 100, rootY, 0.0f, 490.0f, 50.0f, 15.0f, 50.0, 15.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 100, rootY, 0.0f, 540.0f, percentComplete, 15.0f, percentComplete, 15.0, 400.0f, 590.0f);
            percentComplete = (float)Math.floor((float)AdventGuiTabPlayer.tributeLuxon / 200.0f * 50.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 100, rootY + 15, 0.0f, 505.0f, 50.0f, 10.0f, 50.0, 10.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 100, rootY + 15, 0.0f, 555.0f, percentComplete, 10.0f, percentComplete, 10.0, 400.0f, 590.0f);
            percentComplete = (float)Math.floor((float)AdventGuiTabPlayer.tributeErebon / 200.0f * 50.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 100, rootY + 25, 0.0f, 515.0f, 50.0f, 10.0f, 50.0, 10.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 100, rootY + 25, 0.0f, 565.0f, percentComplete, 10.0f, percentComplete, 10.0, 400.0f, 590.0f);
            percentComplete = (float)Math.floor((float)AdventGuiTabPlayer.tributePluton / 200.0f * 50.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 100, rootY + 35, 0.0f, 525.0f, 50.0f, 15.0f, 50.0, 15.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 100, rootY + 35, 0.0f, 575.0f, percentComplete, 15.0f, percentComplete, 15.0, 400.0f, 590.0f);
            percentComplete = (float)Math.floor(AdventGuiTabPlayer.resourceEnergy / 200.0f * 50.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 150, rootY, 0.0f, 90.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 150, rootY, 0.0f, 140.0f, percentComplete, 50.0f, percentComplete, 50.0, 400.0f, 590.0f);
            float currentMax = AuguryUtil.getMaxCreation(AdventGuiTabPlayer.getSkillLevel(Enums.Skills.AUGURY));
            percentComplete = (float)Math.floor(AdventGuiTabPlayer.resourceCreation / currentMax * 50.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 200, rootY, 0.0f, 290.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 200, rootY, 0.0f, 340.0f, percentComplete, 50.0f, percentComplete, 50.0, 400.0f, 590.0f);
            currentMax = AuguryUtil.getMaxSoul(AdventGuiTabPlayer.getSkillLevel(Enums.Skills.AUGURY));
            percentComplete = (float)Math.floor(AdventGuiTabPlayer.resourceSoul / currentMax * 50.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 250, rootY, 0.0f, 390.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX + 250, rootY, 0.0f, 440.0f, percentComplete, 50.0f, percentComplete, 50.0, 400.0f, 590.0f);
            RenderUtil.drawCenteredScaledString(this.mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceRage), rootX + 76, rootY + 28, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(this.mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceEnergy), rootX + 176, rootY + 28, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(this.mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceCreation), rootX + 226, rootY + 28, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(this.mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceSoul), rootX + 276, rootY + 28, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
        } else if (KeyBinder.statusResourceGuiMessage && KeyBinder.keyResourceGui.func_151463_i() != 0) {
            RenderUtil.drawCenteredScaledString(this.mc.field_71466_p, StringUtil.getLocaleStringWithArguments("gui.resources.showTip", KeyBinder.keyResourceGui.getDisplayName()), rootX + 150, rootY + 2, 1.5f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
        }
    }

    private void renderVerticalResources(int rootX, int rootY) {
        if (KeyBinder.statusResourceGui) {
            this.mc.func_110434_K().func_110577_a(resources);
            if (revengeActive) {
                RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY, 0.0f, 500.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            }
            float percentComplete = AdventGuiTabPlayer.resourceRage / 200.0f;
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 50, 0.0f, 190.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 50, AdventGuiTabPlayer.resourceRage >= 150.0f ? 50.0f : 0.0f, 240.0f, percentComplete * 50.0f, 50.0f, percentComplete * 50.0f, 50.0, 400.0f, 590.0f);
            percentComplete = (float)AdventGuiTabPlayer.tributeSelyan / 200.0f;
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 100, 0.0f, 490.0f, 50.0f, 15.0f, 50.0, 15.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 100, 0.0f, 540.0f, percentComplete * 50.0f, 15.0f, percentComplete * 50.0f, 15.0, 400.0f, 590.0f);
            percentComplete = (float)AdventGuiTabPlayer.tributeLuxon / 200.0f;
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 115, 0.0f, 505.0f, 50.0f, 10.0f, 50.0, 10.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 115, 0.0f, 555.0f, percentComplete * 50.0f, 10.0f, percentComplete * 50.0f, 10.0, 400.0f, 590.0f);
            percentComplete = (float)AdventGuiTabPlayer.tributeErebon / 200.0f;
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 125, 0.0f, 515.0f, 50.0f, 10.0f, 50.0, 10.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 125, 0.0f, 565.0f, percentComplete * 50.0f, 10.0f, percentComplete * 50.0f, 10.0, 400.0f, 590.0f);
            percentComplete = (float)AdventGuiTabPlayer.tributePluton / 200.0f;
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 135, 0.0f, 525.0f, 50.0f, 15.0f, 50.0, 15.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 135, 0.0f, 575.0f, percentComplete * 50.0f, 15.0f, percentComplete * 50.0f, 15.0, 400.0f, 590.0f);
            percentComplete = AdventGuiTabPlayer.resourceEnergy / 200.0f;
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 150, 0.0f, 90.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 150, 0.0f, 140.0f, percentComplete * 50.0f, 50.0f, percentComplete * 50.0f, 50.0, 400.0f, 590.0f);
            float currentMax = AuguryUtil.getMaxCreation(AdventGuiTabPlayer.getSkillLevel(Enums.Skills.AUGURY));
            percentComplete = AdventGuiTabPlayer.resourceCreation / currentMax;
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 200, 0.0f, 290.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 200, 0.0f, 340.0f, percentComplete * 50.0f, 50.0f, percentComplete * 50.0f, 50.0, 400.0f, 590.0f);
            currentMax = AuguryUtil.getMaxSoul(AdventGuiTabPlayer.getSkillLevel(Enums.Skills.AUGURY));
            percentComplete = AdventGuiTabPlayer.resourceCreation / currentMax;
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 250, 0.0f, 390.0f, 50.0f, 50.0f, 50.0, 50.0, 400.0f, 590.0f);
            RenderUtil.drawScaledCustomSizeModalRect(rootX, rootY + 250, 0.0f, 440.0f, percentComplete * 50.0f, 50.0f, percentComplete * 50.0f, 50.0, 400.0f, 590.0f);
            RenderUtil.drawCenteredScaledString(this.mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceRage), rootX + 26, rootY + 76, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(this.mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceEnergy), rootX + 26, rootY + 176, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(this.mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceCreation), rootX + 26, rootY + 226, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(this.mc.field_71466_p, String.valueOf((int)AdventGuiTabPlayer.resourceSoul), rootX + 26, rootY + 276, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
        } else if (KeyBinder.statusResourceGuiMessage && KeyBinder.keyResourceGui.func_151463_i() != 0) {
            RenderUtil.drawCenteredScaledString(this.mc.field_71466_p, StringUtil.getLocaleStringWithArguments("gui.resources.showTip", KeyBinder.keyResourceGui.getDisplayName()), rootX + 150, rootY + 2, 1.5f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
        }
    }

    public static enum HudResourcesPosition {
        Top_Right,
        Top_Left,
        Bottom_Right,
        Bottom_Left;

    }
}

