/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.render;

import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.tslat.aoa3.client.event.KeyBinder;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.skills.HunterUtil;
import org.lwjgl.opengl.GL11;

public class EntityPropertiesRenderer {
    @SubscribeEvent
    public void renderIcons(RenderLivingEvent.Specials.Pre<EntityLivingBase> ev) {
        float baseXOffset;
        if (!KeyBinder.statusCreatureStats) {
            return;
        }
        EntityLivingBase entity = ev.getEntity();
        if (entity.field_70165_t == 0.0 && entity.field_70163_u == 0.0 && entity.field_70161_v == 0.0) {
            return;
        }
        int hunterReq = HunterUtil.getHunterLevel(entity);
        int propsSize = 0;
        TreeSet<Enums.MobProperties> mobProps = null;
        if (hunterReq > 0) {
            ++propsSize;
        }
        if (entity instanceof SpecialPropertyEntity) {
            mobProps = ((SpecialPropertyEntity)entity).getMobProperties();
            propsSize += mobProps.size();
        }
        if (hunterReq <= 0 && mobProps == null) {
            return;
        }
        float yOffset = 0.0f;
        float xOffset = baseXOffset = (float)Math.max(-5, -propsSize) * 0.45f / 2.0f + 0.2f;
        float rowMax = 0.875f;
        if (hunterReq > 0) {
            if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d || AdventGuiTabPlayer.getSkillLevel(Enums.Skills.HUNTER) >= hunterReq) {
                this.renderIcon(new ResourceLocation("aoa3", "textures/gui/mobproperties/hunter_entity_available.png"), xOffset, yOffset, ev, new String[0]);
            } else {
                this.renderIcon(new ResourceLocation("aoa3", "textures/gui/mobproperties/hunter_entity_unavailable.png"), xOffset, yOffset, ev, new String[0]);
            }
            xOffset += 0.45f;
        }
        if (mobProps == null) {
            return;
        }
        for (Enums.MobProperties prop : mobProps) {
            switch (prop) {
                case GUN_IMMUNE: {
                    this.renderIcon(new ResourceLocation("aoa3", "textures/gui/mobproperties/gun_immunity.png"), xOffset, yOffset, ev, new String[0]);
                    break;
                }
                case FIRE_IMMUNE: {
                    this.renderIcon(new ResourceLocation("aoa3", "textures/gui/mobproperties/fire_immunity.png"), xOffset, yOffset, ev, new String[0]);
                    break;
                }
                case RANGED_IMMUNE: {
                    this.renderIcon(new ResourceLocation("aoa3", "textures/gui/mobproperties/ranged_immunity.png"), xOffset, yOffset, ev, new String[0]);
                    break;
                }
                case MAGIC_IMMUNE: {
                    this.renderIcon(new ResourceLocation("aoa3", "textures/gui/mobproperties/magic_immunity.png"), xOffset, yOffset, ev, new String[0]);
                    break;
                }
                case MELEE_IMMUNE: {
                    this.renderIcon(new ResourceLocation("aoa3", "textures/gui/mobproperties/melee_immunity.png"), xOffset, yOffset, ev, new String[0]);
                    break;
                }
                case STATUS_IMMUNE: {
                    this.renderIcon(new ResourceLocation("aoa3", "textures/gui/mobproperties/status_immunity.png"), xOffset, yOffset, ev, new String[0]);
                    break;
                }
                case BLASTER_IMMUNE: {
                    this.renderIcon(new ResourceLocation("aoa3", "textures/gui/mobproperties/blaster_immunity.png"), xOffset, yOffset, ev, new String[0]);
                    break;
                }
                case EXPLOSION_IMMUNE: {
                    this.renderIcon(new ResourceLocation("aoa3", "textures/gui/mobproperties/explosion_immunity.png"), xOffset, yOffset, ev, new String[0]);
                    break;
                }
                case SPECIAL_COMBAT_ENTITY: {
                    this.renderIcon(new ResourceLocation("aoa3", "textures/gui/mobproperties/special_combat_entity.png"), xOffset, yOffset, ev, new String[0]);
                }
            }
            if (!((xOffset += 0.45f) > rowMax)) continue;
            yOffset += 0.45f;
            xOffset = baseXOffset;
        }
    }

    private void renderIcon(ResourceLocation texture, float xOffset, float yOffset, RenderLivingEvent.Specials.Pre event, String ... msg) {
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179137_b((double)event.getX(), (double)(0.2 + event.getY() + event.getEntity().func_174813_aQ().field_72337_e - event.getEntity().func_174813_aQ().field_72338_b), (double)event.getZ());
        GlStateManager.func_179114_b((float)(180.0f - mc.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-mc.func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)xOffset, (float)yOffset, (float)0.0f);
        GlStateManager.func_179152_a((float)0.45f, (float)0.45f, (float)0.45f);
        GL11.glDisable((int)2896);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        buffer.func_181662_b(-0.5, -0.25, 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_181662_b(0.5, -0.25, 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_181662_b(0.5, 0.75, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_181662_b(-0.5, 0.75, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tess.func_78381_a();
        GL11.glEnable((int)2896);
        GlStateManager.func_179121_F();
    }
}

