/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.merchants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.utils.StringUtil;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class CorruptedTravellerGui
extends GuiContainer {
    private static final ResourceLocation guiTexture = new ResourceLocation("aoa3", "textures/gui/traders/corrupted_traveller_trade.png");
    private static final ArrayList<ItemStack> validFoods = new ArrayList();
    private long nextFoodTick = 0L;
    private ItemStack currentGhostlyFood = new ItemStack(Items.field_151034_e);
    private final IMerchant corruptedTraveller;
    private String guiTitle;

    public CorruptedTravellerGui(Container container, IMerchant corruptedTraveller) {
        super(container);
        this.corruptedTraveller = corruptedTraveller;
        this.guiTitle = corruptedTraveller.func_145748_c_().func_150261_e();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        int centerX = (this.field_146294_l - this.field_146999_f) / 2;
        int centerY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(centerX, centerY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.renderGhostlyFood(centerX, centerY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int titleWidth = 4 + this.field_146297_k.field_71466_p.func_78256_a(this.guiTitle);
        if (titleWidth > this.field_146999_f - 28 && this.corruptedTraveller instanceof Entity) {
            this.guiTitle = StringUtil.getLocaleString("entity." + EntityList.func_75621_b((Entity)((Entity)this.corruptedTraveller)) + ".name");
            titleWidth = 4 + this.field_146297_k.field_71466_p.func_78256_a(this.guiTitle);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        this.func_73729_b(28, 4, 176, 0, 1, 12);
        for (int i = 0; i < titleWidth - 2; ++i) {
            this.func_73729_b(29 + i, 4, 177, 0, 1, 12);
        }
        this.func_73729_b(28 + titleWidth - 2, 4, 178, 0, 1, 12);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71466_p.func_78276_b(this.guiTitle, 30, 6, 0xFFFFFF);
    }

    private void shadeRenderedStack(ItemStack stack, int posX, int posY) {
        try {
            this.field_73735_i = 100.0f;
            this.field_146296_j.field_77023_b = 150.0f;
            IBakedModel model = this.field_146296_j.func_184393_a(stack, null, (EntityLivingBase)this.field_146297_k.field_71439_g);
            GlStateManager.func_179094_E();
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            this.field_146297_k.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179091_B();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)posX, (float)posY, (float)(100.0f + this.field_146296_j.field_77023_b));
            GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)8.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
            if (model.func_177556_c()) {
                GlStateManager.func_179145_e();
            } else {
                GlStateManager.func_179140_f();
            }
            model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (model.func_188618_c()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179091_B();
                stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
            } else {
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder buff = tess.func_178180_c();
                buff.func_181668_a(7, DefaultVertexFormats.field_176599_b);
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    List quads = model.func_188616_a(null, facing, 0L);
                    for (int i = 0; i < quads.size(); ++i) {
                        LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)((BakedQuad)quads.get(i)), (int)0x70000000);
                    }
                }
                List quads = model.func_188616_a(null, null, 0L);
                for (int i = 0; i < quads.size(); ++i) {
                    LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)((BakedQuad)quads.get(i)), (int)-788529152);
                }
                tess.func_78381_a();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179118_c();
            GlStateManager.func_179101_C();
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            this.field_146297_k.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
            this.field_146296_j.field_77023_b = 0.0f;
            this.field_73735_i = 0.0f;
        }
        catch (Exception e) {
            AdventOfAscension.logMessage(Level.WARN, "Error while rendering itemstack");
            e.printStackTrace();
        }
    }

    private void renderGhostlyFood(int centerX, int centerY) {
        Slot slot = this.field_147002_h.func_75139_a(0);
        if (!slot.func_75216_d()) {
            ItemStack stack = this.getGhostlyStack();
            this.field_146296_j.func_175042_a(stack, slot.field_75223_e + centerX, slot.field_75221_f + centerY);
            this.shadeRenderedStack(stack, slot.field_75223_e + centerX, slot.field_75221_f + centerY);
        }
    }

    @Nonnull
    private ItemStack getGhostlyStack() {
        long worldTick;
        if (validFoods.isEmpty()) {
            validFoods.addAll((Collection<ItemStack>)OreDictionary.getOres((String)"listAllFood"));
        }
        if ((worldTick = Minecraft.func_71410_x().field_71441_e.func_82737_E()) >= this.nextFoodTick) {
            this.currentGhostlyFood = validFoods.get(AdventOfAscension.rand.nextInt(validFoods.size()));
            this.nextFoodTick = worldTick + 20L;
        }
        return this.currentGhostlyFood;
    }
}

