/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.mainwindow;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.gui.lib.ScrollablePane;
import net.tslat.aoa3.client.gui.mainwindow.AdventMainGui;
import net.tslat.aoa3.utils.FileUtil;
import net.tslat.aoa3.utils.RenderUtil;
import org.apache.commons.io.FilenameUtils;

@SideOnly(value=Side.CLIENT)
public class AdventGuiTabGuides
extends GuiScreen {
    private static HashSet<String> guideModIds = new HashSet(2);
    public static ArrayList<InfoBundle> infoBundles = null;
    public static String currentLanguage = "";
    private BundlesMenu scrollMenu;
    private int openBundleIndex = -1;
    private long lastSelectionTime = 0L;
    private int openBundleHeight = 0;
    private List<String> openBundleLines = null;
    private int adjustedMouseX;
    private int adjustedMouseY;

    public void func_73866_w_() {
        if (this.scrollMenu == null) {
            this.scrollMenu = new BundlesMenu(this.field_146297_k, AdventMainGui.scaledTabRootY, AdventMainGui.scaledTabRootX, 340, 764, 0.45f);
        }
        if (infoBundles == null || !AdventMainGui.currentLanguage.equalsIgnoreCase(currentLanguage)) {
            currentLanguage = AdventMainGui.currentLanguage;
            AdventGuiTabGuides.prepAvailableBundles();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.adjustedMouseX = (int)((float)mouseX * 2.2222223f);
        this.adjustedMouseY = (int)((float)mouseY * 2.2222223f);
        this.scrollMenu.drawScreen(this.adjustedMouseX, this.adjustedMouseY, partialTicks);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.scrollMenu.handleMouseInput(-1, -1);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.scrollMenu != null) {
            this.scrollMenu.handleMouseInput(this.adjustedMouseX, this.adjustedMouseY);
        }
    }

    public static void prepAvailableBundles() {
        infoBundles = new ArrayList();
        for (String modId : guideModIds) {
            FileUtil.walkAllAvailableResourceFiles("txt", modId, "lang/aoa3/guides/" + currentLanguage, "lang/aoa3/guides/en_us", reader -> infoBundles.add(new InfoBundle(FileUtil.bufferedReaderToString(reader))));
        }
        File guidesConfigFolder = new File(Loader.instance().getConfigDir(), FilenameUtils.separatorsToSystem((String)"aoa3/data/guides"));
        if (guidesConfigFolder.exists()) {
            FileUtil.walkAllAvailableFiles("txt", new File(guidesConfigFolder, currentLanguage).getAbsolutePath(), new File(guidesConfigFolder, "en_us").getAbsolutePath(), reader -> infoBundles.add(new InfoBundle(FileUtil.bufferedReaderToString(reader))));
        }
    }

    public static void registerGuidesMod(String modid) {
        guideModIds.add(modid);
    }

    public void func_175273_b(Minecraft mcIn, int w, int h) {
        super.func_175273_b(mcIn, w, h);
        if (this.scrollMenu != null) {
            this.scrollMenu.onResize(this.field_146297_k, AdventMainGui.scaledTabRootX, AdventMainGui.scaledTabRootY, 764, 340);
        }
    }

    static {
        guideModIds.add("aoa3");
    }

    private class BundlesMenu
    extends ScrollablePane {
        public BundlesMenu(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float ... currentScale) {
            super(mc, top, left, viewHeight, viewWidth, currentScale);
        }

        @Override
        public int getFullPaneHeight() {
            return AdventGuiTabGuides.this.openBundleIndex < 0 ? infoBundles.size() * 30 : 30 + AdventGuiTabGuides.this.openBundleHeight;
        }

        @Override
        public void drawPaneContents(int top, int left, int right, int bottom, float scrollDistance) {
            int timeAdjustedTop = 0;
            float selectedPercentSwitched = 0.0f;
            if (AdventGuiTabGuides.this.openBundleIndex >= 0) {
                selectedPercentSwitched = Math.min(1.0f, (float)(System.currentTimeMillis() - AdventGuiTabGuides.this.lastSelectionTime) / 400.0f);
                timeAdjustedTop = top + (int)((float)(AdventGuiTabGuides.this.openBundleIndex * 20) * (1.0f - selectedPercentSwitched));
            }
            if (timeAdjustedTop != top) {
                for (int i = Math.max(0, (int)(scrollDistance / 30.0f)); i * 30 <= bottom - top && i < infoBundles.size(); ++i) {
                    InfoBundle bundle = infoBundles.get(i);
                    int rowTop = top + i * 30;
                    int rowBottom = rowTop + 30;
                    Gui.func_73734_a((int)left, (int)rowTop, (int)right, (int)rowBottom, (int)(i % 2 == 0 ? -16711423 : -14671840));
                    RenderUtil.drawCenteredScaledString(AdventGuiTabGuides.this.field_146297_k.field_71466_p, bundle.title, left + (int)((float)this.viewWidth / 2.0f), rowTop + 8, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.NORMAL);
                    RenderUtil.drawScaledString(AdventGuiTabGuides.this.field_146297_k.field_71466_p, "V", left + 5, rowTop + 18, 1.5f, 0xB5B5B5, RenderUtil.StringRenderType.OUTLINED);
                    RenderUtil.drawScaledString(AdventGuiTabGuides.this.field_146297_k.field_71466_p, "V", right - 20, rowTop + 18, 1.5f, 0xB5B5B5, RenderUtil.StringRenderType.OUTLINED);
                }
            }
            if (AdventGuiTabGuides.this.openBundleIndex >= 0) {
                InfoBundle bundle = infoBundles.get(AdventGuiTabGuides.this.openBundleIndex);
                if (AdventGuiTabGuides.this.openBundleLines == null) {
                    AdventGuiTabGuides.this.openBundleLines = AdventGuiTabGuides.this.field_146297_k.field_71466_p.func_78271_c(bundle.info, (int)((float)(this.viewWidth - 30) / 1.5f));
                    AdventGuiTabGuides.this.openBundleHeight = Math.max(this.viewHeight - 30, 25 + (int)((float)AdventGuiTabGuides.this.openBundleLines.size() * ((float)AdventGuiTabGuides.this.field_146297_k.field_71466_p.field_78288_b * 1.5f)));
                }
                int timeAdjustedBottom = (int)((float)(timeAdjustedTop + 30) + (float)AdventGuiTabGuides.this.openBundleHeight * selectedPercentSwitched);
                Gui.func_73734_a((int)left, (int)timeAdjustedTop, (int)right, (int)(timeAdjustedTop + 30), (int)(AdventGuiTabGuides.this.openBundleIndex % 2 == 0 ? -16711423 : -14671840));
                RenderUtil.drawCenteredScaledString(AdventGuiTabGuides.this.field_146297_k.field_71466_p, bundle.title, left + (int)((float)this.viewWidth / 2.0f), timeAdjustedTop + 8, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.NORMAL);
                RenderUtil.drawScaledString(AdventGuiTabGuides.this.field_146297_k.field_71466_p, "^", left + 5, timeAdjustedTop + 18, 1.5f, 0xB5B5B5, RenderUtil.StringRenderType.OUTLINED);
                RenderUtil.drawScaledString(AdventGuiTabGuides.this.field_146297_k.field_71466_p, "^", right - 20, timeAdjustedTop + 18, 1.5f, 0xB5B5B5, RenderUtil.StringRenderType.OUTLINED);
                Gui.func_73734_a((int)left, (int)(timeAdjustedTop + 30), (int)right, (int)timeAdjustedBottom, (int)-11513776);
                if (selectedPercentSwitched == 1.0f) {
                    int lineOffset = 0;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
                    for (String s : AdventGuiTabGuides.this.openBundleLines) {
                        AdventGuiTabGuides.this.field_146297_k.field_71466_p.func_78276_b(s, (int)((float)(left + 20) / 1.5f), (int)((float)(top + 30 + lineOffset) / 1.5f), 0xFFFFFF);
                        lineOffset += 14;
                    }
                    GlStateManager.func_179121_F();
                }
            }
        }

        @Override
        public void drawBackground() {
        }

        @Override
        public void handleMouseInput(int mouseX, int mouseY) {
            super.handleMouseInput(mouseX, mouseY);
            if (mouseX != -1) {
                int relativeMouseX = mouseX - this.left + 2;
                if (relativeMouseX < 0 || relativeMouseX > this.viewWidth - 6) {
                    return;
                }
                int newTop = this.top - Math.max(0, (int)this.distanceScrolled);
                int relativeMouseY = mouseY - newTop + 2;
                if (mouseY - this.top < 0 || mouseY > this.top + this.viewHeight) {
                    return;
                }
                if (AdventGuiTabGuides.this.openBundleIndex < 0) {
                    int selectedIndex = relativeMouseY / 30;
                    if (infoBundles.size() > selectedIndex) {
                        AdventGuiTabGuides.this.openBundleIndex = selectedIndex;
                        AdventGuiTabGuides.this.lastSelectionTime = System.currentTimeMillis();
                        AdventGuiTabGuides.this.openBundleHeight = 600;
                        this.distanceScrolled = 0.0f;
                    }
                } else if (relativeMouseY <= 30) {
                    AdventGuiTabGuides.this.openBundleIndex = -1;
                    AdventGuiTabGuides.this.openBundleHeight = 0;
                    AdventGuiTabGuides.this.openBundleLines = null;
                }
            }
        }
    }

    public static class InfoBundle {
        protected final String title;
        protected final String info;

        public InfoBundle(String lines) {
            String[] data = lines.split("\n", 2);
            this.title = data[0];
            this.info = data[1];
        }
    }
}

