/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.blocks;

import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.containers.ContainerFrameBench;
import net.tslat.aoa3.common.packet.PacketGuiData;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.item.misc.FrameItem;
import net.tslat.aoa3.utils.PacketUtil;
import net.tslat.aoa3.utils.StringUtil;

@SideOnly(value=Side.CLIENT)
public class GuiFrameBench
extends GuiContainer {
    private static final ResourceLocation textures = new ResourceLocation("aoa3", "textures/gui/containers/frame_bench.png");
    private static String currentSelection = "helmet";
    private static RenderItem itemRenderer;

    public GuiFrameBench(EntityPlayer player) {
        super((Container)new ContainerFrameBench(player, player.field_70170_p, BlockPos.field_177992_a));
        currentSelection = "helmet";
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new FrameSelectButton(0, this.field_147003_i + 45, this.field_147009_r + 33, "Helmet", "helmet", ItemRegister.HELMET_FRAME));
        this.field_146292_n.add(new FrameSelectButton(1, this.field_147003_i + 65, this.field_147009_r + 33, "Chestplate", "chestplate", ItemRegister.CHESTPLATE_FRAME));
        this.field_146292_n.add(new FrameSelectButton(2, this.field_147003_i + 85, this.field_147009_r + 33, "Leggings", "leggings", ItemRegister.LEGGINGS_FRAME));
        this.field_146292_n.add(new FrameSelectButton(3, this.field_147003_i + 105, this.field_147009_r + 33, "Boots", "boots", ItemRegister.BOOTS_FRAME));
        this.field_146292_n.add(new FrameSelectButton(4, this.field_147003_i + 55, this.field_147009_r + 13, "Archergun", "archergun", ItemRegister.ARCHERGUN_FRAME));
        this.field_146292_n.add(new FrameSelectButton(5, this.field_147003_i + 75, this.field_147009_r + 13, "Blaster", "blaster", ItemRegister.BLASTER_FRAME));
        this.field_146292_n.add(new FrameSelectButton(6, this.field_147003_i + 95, this.field_147009_r + 13, "Cannon", "cannon", ItemRegister.CANNON_FRAME));
        this.field_146292_n.add(new FrameSelectButton(7, this.field_147003_i + 55, this.field_147009_r + 53, "Gun", "gun", ItemRegister.GUN_FRAME));
        this.field_146292_n.add(new FrameSelectButton(8, this.field_147003_i + 75, this.field_147009_r + 53, "Shotgun", "shotgun", ItemRegister.SHOTGUN_FRAME));
        this.field_146292_n.add(new FrameSelectButton(9, this.field_147003_i + 95, this.field_147009_r + 53, "Sniper", "sniper", ItemRegister.SNIPER_FRAME));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        for (GuiButton button : this.field_146292_n) {
            if (!button.func_146115_a() || !(button instanceof FrameSelectButton)) continue;
            ((FrameSelectButton)button).renderHoverTooltip(this.field_146297_k, mouseX, mouseY);
            break;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(textures);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof FrameSelectButton && this.field_146297_k.field_71439_g.field_71070_bA instanceof ContainerFrameBench) {
            currentSelection = ((FrameSelectButton)button).selectionValue;
            PacketUtil.network.sendToServer((IMessage)new PacketGuiData("FrameBenchSelect", currentSelection));
            ((ContainerFrameBench)this.field_146297_k.field_71439_g.field_71070_bA).changeSelection(currentSelection);
        }
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        itemRenderer = this.field_146296_j;
    }

    private static class FrameSelectButton
    extends GuiButton {
        private static final int buttonWidth = 18;
        private static final int buttonHeight = 18;
        private final String selectionValue;
        private final FrameItem frame;

        private FrameSelectButton(int buttonId, int x, int y, String buttonText, String selectionValue, FrameItem frame) {
            super(buttonId, x, y, 18, 18, buttonText);
            this.selectionValue = selectionValue;
            this.frame = frame;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            mc.func_110434_K().func_110577_a(textures);
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = this.isMouseInRegion(mouseX, mouseY, this.field_146128_h, this.field_146129_i);
            int textureX = 176;
            int textureY = 21 + 18 * (this.selectionValue.equals(currentSelection) ? 0 : (this.func_146114_a(this.field_146123_n) == 2 ? 2 : 1));
            this.func_73729_b(this.field_146128_h, this.field_146129_i, textureX, textureY, 18, 18);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
            itemRenderer.func_175042_a(new ItemStack((Item)this.frame), this.field_146128_h + 1, this.field_146129_i + 1);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public void renderHoverTooltip(Minecraft mc, int mouseX, int mouseY) {
            ItemStack stack = new ItemStack((Item)this.frame);
            ScaledResolution res = new ScaledResolution(mc);
            GuiUtils.drawHoveringText((ItemStack)stack, Collections.singletonList(StringUtil.getLocaleString(this.frame.func_77658_a() + ".name")), (int)mouseX, (int)mouseY, (int)res.func_78326_a(), (int)res.func_78328_b(), (int)-1, (FontRenderer)mc.field_71466_p);
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= buttonX && mouseX <= buttonX + 18 && mouseY >= buttonY && mouseY <= buttonY + 18;
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            return this.field_146124_l && this.field_146123_n && !currentSelection.equals(this.selectionValue);
        }
    }
}

