/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.event;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.event.KeyBinder;
import net.tslat.aoa3.client.gui.render.HelmetScreenRenderer;
import net.tslat.aoa3.client.gui.render.ScreenOverlayRenderer;
import net.tslat.aoa3.client.gui.render.SniperGuiRenderer;
import net.tslat.aoa3.client.sound.MusicSound;
import net.tslat.aoa3.common.packet.PacketChangedHalo;
import net.tslat.aoa3.common.packet.PacketLongReachWeaponHit;
import net.tslat.aoa3.item.armour.ScreenOverlayArmour;
import net.tslat.aoa3.item.weapon.LongReachWeapon;
import net.tslat.aoa3.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.PacketUtil;
import net.tslat.aoa3.utils.StringUtil;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    public static int tick;
    public static int recoilTicks;
    public static int recoilTicksRemaining;
    public static float recoilAngle;

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            EntityPlayerSP player;
            if (++tick > 24000) {
                tick = 0;
            }
            if (ScreenOverlayRenderer.overlayTicks > 0) {
                --ScreenOverlayRenderer.overlayTicks;
            }
            if (recoilTicksRemaining > 0) {
                --recoilTicksRemaining;
                this.doRecoil();
            }
            if ((player = Minecraft.func_71410_x().field_71439_g) == null) {
                return;
            }
            if (player.func_70093_af() && player.field_70122_E) {
                Item sniper = player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
                if (sniper instanceof BaseSniper) {
                    SniperGuiRenderer.isSniping = true;
                    SniperGuiRenderer.screen = ((BaseSniper)sniper).getScreen();
                } else {
                    SniperGuiRenderer.isSniping = false;
                }
            } else {
                SniperGuiRenderer.isSniping = false;
                if (SniperGuiRenderer.screen != null) {
                    recoilTicks = 5;
                    recoilTicksRemaining = 5;
                    recoilAngle = 1.0f;
                    SniperGuiRenderer.screen = null;
                }
            }
            HelmetScreenRenderer.active = false;
            Item helmetItem = ((ItemStack)player.field_71071_by.field_70460_b.get(3)).func_77973_b();
            if (!SniperGuiRenderer.isSniping && helmetItem instanceof ScreenOverlayArmour) {
                HelmetScreenRenderer.screen = ((ScreenOverlayArmour)helmetItem).getOverlay();
                HelmetScreenRenderer.active = true;
            }
        }
    }

    @SubscribeEvent
    public void configChanged(ConfigChangedEvent.OnConfigChangedEvent ev) {
        if (ev.getModID().equals("aoa3")) {
            ConfigManager.sync((String)"aoa3", (Config.Type)Config.Type.INSTANCE);
            PacketUtil.network.sendToServer((IMessage)new PacketChangedHalo(ConfigurationUtil.MainConfig.personalHaloPreference));
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onLongReachSwing(MouseEvent ev) {
        if (ev.isButtonstate() && ev.getButton() != -1 && ev.getButton() == -100 - Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151463_i()) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (player != null) {
                RayTraceResult ray;
                if (player.func_175149_v()) {
                    return;
                }
                ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
                if (stack.func_77973_b() instanceof LongReachWeapon && !player.func_184587_cr() && (ray = ClientEventHandler.getExtendedReachRayTrace(((LongReachWeapon)stack.func_77973_b()).getReach())) != null) {
                    PacketUtil.network.sendToServer((IMessage)new PacketLongReachWeaponHit(ray.field_72308_g.func_145782_y()));
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent ev) {
        if (ConfigurationUtil.MainConfig.showWelcomeMessage) {
            int adventGuiKeyCode = KeyBinder.keyAdventGui.func_151463_i();
            if (adventGuiKeyCode == 0) {
                ev.player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.login.welcome.alt", TextFormatting.GRAY));
            } else if (adventGuiKeyCode > 0) {
                ev.player.func_145747_a((ITextComponent)StringUtil.getColourLocaleWithArguments("message.login.welcome", TextFormatting.GRAY, Keyboard.getKeyName((int)adventGuiKeyCode)));
            }
        }
        PacketUtil.network.sendToServer((IMessage)new PacketChangedHalo(ConfigurationUtil.MainConfig.personalHaloPreference));
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent ev) {
        if (ev.getEntity() instanceof EntityPlayer) {
            ScreenOverlayRenderer.overlayTicks = 0;
        }
    }

    private static RayTraceResult getExtendedReachRayTrace(float distance) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity player = mc.func_175606_aa();
        if (player != null && player.field_70170_p != null) {
            Vec3d lookVec = player.func_70676_i(mc.func_184121_ak());
            Vec3d eyesVec = player.func_174824_e(mc.func_184121_ak());
            Vec3d extendedEyesVec = eyesVec.func_72441_c(lookVec.field_72450_a * (double)distance, lookVec.field_72448_b * (double)distance, lookVec.field_72449_c * (double)distance);
            List collisionList = mc.field_71441_e.func_175674_a(player, player.func_174813_aQ().func_72321_a(lookVec.field_72450_a * (double)distance, lookVec.field_72448_b * (double)distance, lookVec.field_72449_c * (double)distance).func_72314_b(0.5, 0.5, 0.5), Predicates.and((Predicate)EntitySelectors.field_180132_d, entity -> !entity.field_70128_L));
            Entity closestTarget = null;
            double closestDistance = distance + 1.0f;
            Vec3d closestHitVec = null;
            for (int i = collisionList.size() - 1; i >= 0; --i) {
                double collidedDistance;
                Entity collided = (Entity)collisionList.get(i);
                AxisAlignedBB axis = collided.func_174813_aQ().func_186662_g((double)collided.func_70111_Y());
                RayTraceResult collisionRay = axis.func_72327_a(eyesVec, extendedEyesVec);
                if (axis.func_72318_a(eyesVec)) {
                    if (!(closestDistance > 0.0)) continue;
                    closestTarget = collided;
                    closestHitVec = collisionRay == null ? eyesVec : collisionRay.field_72307_f;
                    closestDistance = 0.0;
                    continue;
                }
                if (collisionRay == null || !((collidedDistance = eyesVec.func_72438_d(collisionRay.field_72307_f)) < closestDistance) && closestDistance != 0.0) continue;
                if (collided.func_184208_bv() == player.func_184208_bv() && !collided.canRiderInteract()) {
                    if (closestDistance != 0.0) continue;
                    closestTarget = collided;
                    closestHitVec = collisionRay.field_72307_f;
                    continue;
                }
                closestTarget = collided;
                closestHitVec = collisionRay.field_72307_f;
                closestDistance = collidedDistance;
            }
            if (closestTarget != null && eyesVec.func_72438_d(closestHitVec) <= (double)distance && (mc.field_71476_x == null || mc.field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK)) {
                return new RayTraceResult(closestTarget, closestHitVec);
            }
        }
        return null;
    }

    private void doRecoil() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        player.field_70125_A = recoilTicksRemaining >= recoilTicks - 5 ? player.field_70125_A - recoilAngle / (4.0f * (float)(SniperGuiRenderer.isSniping ? 4 : 1)) : player.field_70125_A + recoilAngle / (35.0f * (float)(SniperGuiRenderer.isSniping ? 2 : 1));
    }

    @SubscribeEvent
    public void onMusicPlay(PlaySoundEvent ev) {
        if (ev.getSound() != null && ev.getSound().func_184365_d() == SoundCategory.MUSIC && !(ev.getSound() instanceof MusicSound) && MusicSound.currentlyBlockingMusic()) {
            ev.setResultSound(null);
        }
    }
}

