/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.generation.plants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;

public class PlantStackable
extends Block
implements IShearable {
    protected PlantStackable hatBlock;
    protected PlantStackable stemBlock;
    protected final List<Material> growthMaterials;

    public PlantStackable(String name, String registryName, Material material, float hardness, Material ... growthMaterial) {
        super(material);
        this.func_149663_c(name);
        this.func_149711_c(hardness);
        this.func_149672_a(SoundType.field_185850_c);
        this.setRegistryName("aoa3:" + registryName);
        this.hatBlock = this;
        this.stemBlock = this;
        this.growthMaterials = Arrays.asList(growthMaterial);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabsRegister.GENERATION_BLOCKS);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && !this.func_176196_c(world, pos)) {
            if (this.func_149745_a(rand) > 0) {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_175698_g(pos);
        }
    }

    public PlantStackable(String name, String registryName, Material ... growthMaterials) {
        this(name, registryName, Material.field_151585_k, 0.1f, growthMaterials);
    }

    public PlantStackable setStemBlock(PlantStackable block) {
        this.stemBlock = block;
        block.hatBlock = this;
        return this;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState targetState = world.func_180495_p(pos.func_177977_b());
        return (this.growthMaterials.isEmpty() || this.growthMaterials.contains(targetState.func_185904_a())) && targetState.func_185914_p() || targetState.func_177230_c() == this.stemBlock;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        pos = pos.func_177984_a();
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        while (block == this.stemBlock || block == this.hatBlock) {
            if (block.func_149745_a(RANDOM) > 0) {
                block.func_176226_b(world, pos, blockState, 0);
            }
            world.func_175698_g(pos);
            pos = pos.func_177984_a();
            blockState = world.func_180495_p(pos);
            block = blockState.func_177230_c();
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            if (this.func_149745_a(RANDOM) > 0) {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_175698_g(pos);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        if (world instanceof World) {
            this.func_180663_b((World)world, pos, world.func_180495_p(pos));
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(new ItemStack(Item.func_150898_a((Block)this)));
            return drops;
        }
        return new ArrayList<ItemStack>();
    }
}

