/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.generation.plants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.generation.plants.PlantStackable;

public class PlantMultiStackable
extends PlantStackable {
    protected List<PlantStackable> stemBlocks = new ArrayList<PlantStackable>();

    public PlantMultiStackable(String name, String registryName, Material material, float hardness, Material ... growthMaterial) {
        super(name, registryName, material, hardness, growthMaterial);
        this.stemBlocks.add(this);
    }

    public PlantMultiStackable(String name, String registryName, Material ... growthMaterials) {
        super(name, registryName, growthMaterials);
        this.stemBlocks.add(this);
    }

    public PlantMultiStackable addStemBlock(PlantMultiStackable ... blocks) {
        this.stemBlocks.addAll(Arrays.asList(blocks));
        for (PlantMultiStackable bl : blocks) {
            bl.stemBlocks.add(this);
        }
        return this;
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState targetState = world.func_180495_p(pos.func_177977_b());
        return (this.growthMaterials.isEmpty() || this.growthMaterials.contains(targetState.func_185904_a())) && targetState.func_185914_p() || this.stemBlocks.contains(targetState.func_177230_c());
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        pos = pos.func_177984_a();
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        while (this.stemBlocks.contains(block) || block == this.hatBlock) {
            if (block.func_149745_a(RANDOM) > 0) {
                block.func_176226_b(world, pos, blockState, 0);
            }
            world.func_175698_g(pos);
            pos = pos.func_177984_a();
            blockState = world.func_180495_p(pos);
            block = blockState.func_177230_c();
        }
    }
}

