/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.ArmourRegister;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;

public class LunarCreationTable
extends Block {
    public LunarCreationTable() {
        super(Material.field_151576_e);
        this.func_149663_c("LunarCreationTable");
        this.setRegistryName("aoa3:lunar_creation_table");
        this.func_149711_c(-1.0f);
        this.func_149752_b(1.0E9f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabsRegister.FUNCTIONAL_BLOCKS);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            BlockPos lunarPos = null;
            BlockPos moonlightPos = null;
            BlockPos darklightPos = null;
            BlockPos sunfirePos = null;
            BlockPos duskPos = null;
            for (int x = -2; x <= 2; x += 2) {
                for (int z = -2; z <= 2; z += 2) {
                    BlockPos checkPos = pos.func_177982_a(x, 0, z);
                    IBlockState block = world.func_180495_p(checkPos);
                    if (block.func_177230_c() == BlockRegister.LUNAR_ORB) {
                        lunarPos = checkPos;
                        continue;
                    }
                    if (block.func_177230_c() == BlockRegister.MOONLIGHT_ORB) {
                        moonlightPos = checkPos;
                        continue;
                    }
                    if (block.func_177230_c() == BlockRegister.DARKLIGHT_ORB) {
                        darklightPos = checkPos;
                        continue;
                    }
                    if (block.func_177230_c() == BlockRegister.DUSK_ORB) {
                        duskPos = checkPos;
                        continue;
                    }
                    if (block.func_177230_c() != BlockRegister.SUNFIRE_ORB) continue;
                    sunfirePos = checkPos;
                }
            }
            if (lunarPos != null && moonlightPos != null) {
                if (darklightPos != null && sunfirePos != null && duskPos != null) {
                    HashSet<Item> armours = new HashSet<Item>(4);
                    armours.add(ArmourRegister.LUNAR_BOOTS);
                    armours.add(ArmourRegister.LUNAR_LEGS);
                    armours.add(ArmourRegister.LUNAR_CHESTPLATE);
                    armours.add(ArmourRegister.LUNAR_HELMET);
                    for (ItemStack stack : player.field_71071_by.field_70462_a) {
                        armours.removeIf(item -> item == stack.func_77973_b());
                    }
                    for (ItemStack stack : player.field_71071_by.field_70460_b) {
                        armours.removeIf(item -> item == stack.func_77973_b());
                    }
                    for (ItemStack stack : player.field_71071_by.field_70460_b) {
                        armours.removeIf(item -> item == stack.func_77973_b());
                    }
                    if (armours.isEmpty()) {
                        armours.add(ArmourRegister.LUNAR_BOOTS);
                        armours.add(ArmourRegister.LUNAR_LEGS);
                        armours.add(ArmourRegister.LUNAR_CHESTPLATE);
                        armours.add(ArmourRegister.LUNAR_HELMET);
                    }
                    Item armourPiece = (Item)armours.toArray()[player.func_70681_au().nextInt(armours.size())];
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, new ItemStack(armourPiece)));
                    world.func_175698_g(lunarPos);
                    world.func_175698_g(moonlightPos);
                    world.func_175698_g(duskPos);
                    world.func_175698_g(sunfirePos);
                    world.func_175698_g(darklightPos);
                } else {
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, new ItemStack((Item)ItemRegister.OBSERVING_EYE)));
                    world.func_175698_g(lunarPos);
                    world.func_175698_g(moonlightPos);
                }
            }
        }
        return true;
    }
}

