/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.misc;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.entity.boss.vinocorne.EntityVinocorne;

public class LivingGrowth
extends Block {
    private static final PropertyInteger GROWTH_STAGE = PropertyInteger.func_177719_a((String)"growth", (int)0, (int)5);
    private static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.5, 0.8125), new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375), new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.4375, 0.9375), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.625, 1.0)};

    public LivingGrowth() {
        super(Material.field_151585_k);
        this.func_149663_c("LivingGrowth");
        this.setRegistryName("aoa3:living_growth");
        this.func_149711_c(1.0f);
        this.func_149752_b(0.0f);
        this.func_149647_a(null);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)GROWTH_STAGE, (Comparable)Integer.valueOf(0)));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB[(Integer)state.func_177229_b((IProperty)GROWTH_STAGE)];
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        int currentAge = (Integer)state.func_177229_b((IProperty)GROWTH_STAGE);
        if (currentAge < 6) {
            if (currentAge == 5) {
                EntityVinocorne vinocorne = new EntityVinocorne(world);
                vinocorne.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                world.func_72838_d((Entity)vinocorne);
                world.func_175698_g(pos);
            } else {
                world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)GROWTH_STAGE, (Comparable)Integer.valueOf(currentAge + 1)));
                world.func_175684_a(pos, state.func_177230_c(), 40);
            }
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != BlockRegister.VINOCORNE_SHRINE) {
            ((World)world).func_175698_g(pos);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{GROWTH_STAGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)GROWTH_STAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)GROWTH_STAGE);
    }
}

