/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.altar;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.tslat.aoa3.block.BasicBlock;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public abstract class BossAltarBlock
extends BasicBlock {
    public BossAltarBlock(String name, String registryName) {
        super(name, registryName, Material.field_151576_e, -1.0f, 1.0E9f);
        this.func_149647_a(CreativeTabsRegister.FUNCTIONAL_BLOCKS);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.getActivationItem() != null && heldItem.func_77973_b() != this.getActivationItem()) {
            return false;
        }
        if (!(world.field_72995_K || this.getActivationItem() != null && heldItem.func_77973_b() != this.getActivationItem())) {
            if (world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                PlayerUtil.getAdventPlayer(player).sendThrottledChatMessage("message.feedback.spawnBoss.difficultyFail", new Object[0]);
                return false;
            }
            if (this.checkActivationConditions(player, hand, state, pos)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                this.doActivationEffect(player, hand, state, pos);
            }
        }
        return true;
    }

    @Nullable
    protected abstract Item getActivationItem();

    protected abstract void doActivationEffect(EntityPlayer var1, EnumHand var2, IBlockState var3, BlockPos var4);

    protected boolean checkActivationConditions(EntityPlayer player, EnumHand hand, IBlockState state, BlockPos pos) {
        return true;
    }

    protected void sendSpawnMessage(EntityPlayer player, TextComponentTranslation msg, BlockPos pos) {
        StringUtil.sendMessageWithinRadius(msg, (Entity)player, 50);
    }
}

