/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.altar;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.block.functional.altar.BossAltarBlock;
import net.tslat.aoa3.entity.boss.skeletalarmy.EntityEliteSkeleHopper;
import net.tslat.aoa3.entity.boss.skeletalarmy.EntityEliteSkelePig;
import net.tslat.aoa3.entity.boss.skeletalarmy.EntityEliteSkeleman;
import net.tslat.aoa3.entity.boss.skeletalarmy.EntitySkeleElder;
import net.tslat.aoa3.entity.boss.skeletalarmy.EntitySkeleHopper;
import net.tslat.aoa3.entity.boss.skeletalarmy.EntitySkelePig;
import net.tslat.aoa3.entity.boss.skeletalarmy.EntitySkeleman;
import net.tslat.aoa3.entity.boss.skeletalarmy.EntitySkeletron;
import net.tslat.aoa3.entity.boss.skeletalarmy.EntityStrongSkeleHopper;
import net.tslat.aoa3.entity.boss.skeletalarmy.EntityStrongSkelePig;
import net.tslat.aoa3.entity.boss.skeletalarmy.EntityStrongSkeleman;
import net.tslat.aoa3.utils.StringUtil;

public class ArmyBlock
extends BossAltarBlock {
    public ArmyBlock() {
        super("ArmyBlock", "army_block");
        this.func_149675_a(true);
    }

    @Override
    protected boolean checkActivationConditions(EntityPlayer player, EnumHand hand, IBlockState state, BlockPos pos) {
        if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_175647_a(EntityMob.class, new AxisAlignedBB(pos).func_186662_g(100.0), entity -> entity instanceof EntitySkeleElder || entity instanceof EntitySkeletron).size() == 0) {
            EntitySkeleElder skeleElder = new EntitySkeleElder(player.field_70170_p, pos, 0);
            skeleElder.func_70107_b(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
            player.field_70170_p.func_72838_d((Entity)skeleElder);
        }
        return false;
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K && random.nextBoolean() && world.func_72872_a(EntitySkeleElder.class, new AxisAlignedBB(pos).func_186662_g(100.0)).isEmpty()) {
            world.func_72838_d((Entity)new EntitySkeleElder(world, pos, 0));
        }
    }

    @Override
    protected void doActivationEffect(EntityPlayer player, EnumHand hand, IBlockState state, BlockPos blockPos) {
        ArmyBlock.spawnWave(player.field_70170_p, blockPos, 1);
        this.sendSpawnMessage(player, StringUtil.getLocaleWithArguments("message.mob.skeletalArmy.spawn", player.getDisplayNameString()), blockPos);
    }

    private static void spawnWaveEntities(World world, BlockPos armyBlockPos, Entity ... entities) {
        for (Entity entity : entities) {
            int posX = armyBlockPos.func_177958_n() - 17 + AdventOfAscension.rand.nextInt(23);
            int posZ = armyBlockPos.func_177952_p() - 11 + AdventOfAscension.rand.nextInt(19);
            BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(posX, armyBlockPos.func_177956_o(), posZ);
            while (checkPos.func_177956_o() < world.func_72800_K() && !world.func_175623_d((BlockPos)checkPos.func_189536_c(EnumFacing.UP))) {
            }
            entity.func_70107_b((double)posX, (double)checkPos.func_177956_o(), (double)posZ);
            world.func_72838_d(entity);
        }
    }

    public static void spawnWave(World world, BlockPos blockPos, int wave) {
        if (!world.field_72995_K) {
            switch (wave) {
                case 1: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntitySkelePig(world), new EntitySkelePig(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 2: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntitySkeleHopper(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 3: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntitySkeleHopper(world), new EntitySkeleHopper(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 4: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntitySkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 5: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntitySkeleman(world), new EntitySkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 6: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntitySkelePig(world), new EntitySkeleHopper(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 7: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntitySkelePig(world), new EntitySkeleHopper(world), new EntitySkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 8: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntitySkelePig(world), new EntitySkelePig(world), new EntitySkeleHopper(world), new EntitySkeleHopper(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 9: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntitySkelePig(world), new EntitySkelePig(world), new EntitySkeleHopper(world), new EntitySkeleHopper(world), new EntitySkeleman(world), new EntitySkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 10: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntitySkeleman(world), new EntitySkeleman(world), new EntitySkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 11: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntitySkelePig(world), new EntitySkelePig(world), new EntitySkelePig(world), new EntitySkeleman(world), new EntitySkeleman(world), new EntitySkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 12: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityStrongSkelePig(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 13: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityStrongSkeleHopper(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 14: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityStrongSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 15: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityStrongSkelePig(world), new EntityStrongSkelePig(world), new EntityStrongSkelePig(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 16: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityStrongSkeleHopper(world), new EntityStrongSkeleHopper(world), new EntityStrongSkeleHopper(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 17: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityStrongSkeleman(world), new EntityStrongSkeleman(world), new EntityStrongSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 18: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityStrongSkelePig(world), new EntityStrongSkelePig(world), new EntityStrongSkeleHopper(world), new EntityStrongSkeleHopper(world), new EntityStrongSkeleman(world), new EntityStrongSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 19: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntitySkelePig(world), new EntitySkelePig(world), new EntitySkeleHopper(world), new EntitySkeleHopper(world), new EntitySkeleman(world), new EntitySkeleman(world), new EntityStrongSkelePig(world), new EntityStrongSkelePig(world), new EntityStrongSkeleHopper(world), new EntityStrongSkeleHopper(world), new EntityStrongSkeleman(world), new EntityStrongSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 20: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkelePig(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 21: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkeleHopper(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 22: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 23: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 24: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 25: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 26: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 27: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 28: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 29: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityStrongSkeleman(world), new EntityStrongSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 30: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 31: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 32: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 33: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 34: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 35: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 36: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityStrongSkelePig(world), new EntityStrongSkelePig(world), new EntityStrongSkeleHopper(world), new EntityStrongSkeleHopper(world), new EntityStrongSkeleman(world), new EntityStrongSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 37: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 38: {
                    ArmyBlock.spawnWaveEntities(world, blockPos, new Entity[]{new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkelePig(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleHopper(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntityEliteSkeleman(world), new EntitySkeleElder(world, blockPos, wave)});
                    break;
                }
                case 39: {
                    world.func_72838_d((Entity)new EntitySkeletron(world, blockPos));
                    break;
                }
            }
        }
    }

    @Override
    protected Item getActivationItem() {
        return null;
    }
}

