/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent;

import com.google.common.collect.ImmutableList;
import java.time.LocalDate;
import java.time.Month;
import java.util.Random;
import java.util.UUID;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.tslat.aoa3.capabilities.CapabilitiesManager;
import net.tslat.aoa3.capabilities.handlers.AdventMiscStackCapability;
import net.tslat.aoa3.capabilities.handlers.AdventMiscStackSerializeableCapability;
import net.tslat.aoa3.capabilities.handlers.AdventPlayerCapability;
import net.tslat.aoa3.capabilities.interfaces.CapabilityBaseMiscStack;
import net.tslat.aoa3.capabilities.interfaces.CapabilityBaseMiscStackSerializable;
import net.tslat.aoa3.capabilities.interfaces.CapabilityBasePlayer;
import net.tslat.aoa3.capabilities.storages.AdventMiscStackSerializableStorage;
import net.tslat.aoa3.capabilities.storages.AdventMiscStackStorage;
import net.tslat.aoa3.capabilities.storages.AdventPlayerStorage;
import net.tslat.aoa3.command.CommandAoAEvent;
import net.tslat.aoa3.command.CommandAoAPortalReset;
import net.tslat.aoa3.command.CommandAoASkill;
import net.tslat.aoa3.command.CommandAoAStructure;
import net.tslat.aoa3.command.CommandAoAWiki;
import net.tslat.aoa3.command.CommandTslat;
import net.tslat.aoa3.common.ServerProxy;
import net.tslat.aoa3.common.registration.AdvancementTriggerRegister;
import net.tslat.aoa3.common.registration.BiomeRegister;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.DimensionRegister;
import net.tslat.aoa3.common.registration.EntitySpawnRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.RecipeRegister;
import net.tslat.aoa3.dimension.WorldGen;
import net.tslat.aoa3.event.EntityEvents;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.event.PlayerEvents;
import net.tslat.aoa3.event.WorldEvents;
import net.tslat.aoa3.hooks.ThirdPartyInteractions;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.BannerUtil;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.PacketUtil;
import net.tslat.aoa3.utils.WebUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="aoa3", version="3.3.6", useMetadata=true, acceptedMinecraftVersions="1.12.2", updateJSON="https://gist.github.com/Tslat/e7afe2448fe39a695acd45764824b762/raw/", dependencies="required-after:forge@[14.23.5.2846,);", certificateFingerprint="8bddeac148843f40e0b9f69201be2f4b3071700d")
public class AdventOfAscension {
    @Mod.Instance(value="aoa3")
    private static AdventOfAscension instance;
    @SidedProxy(clientSide="net.tslat.aoa3.common.ClientProxy", serverSide="net.tslat.aoa3.common.ServerProxy")
    public static ServerProxy proxy;
    private static Logger logger;
    private PlayerEvents playerEvents;
    public static final String version = "3.3.6";
    public static final Random rand;
    private final UUID UUIDTslat = UUID.fromString("2459b511-ca45-43d8-808d-f0eb30a63be4");
    private final UUID UUIDUrsun = UUID.fromString("69144818-2721-420d-ba56-3ec2b6176ae1");
    public final Holiday holiday;

    public AdventOfAscension() {
        ModUtil.modConstructTasks();
        this.holiday = this.getCurrentHoliday();
    }

    @Mod.EventHandler
    public void fmlPreInit(FMLPreInitializationEvent preInit) {
        AdventOfAscension.logOptionalMessage("AoA3 - 3.3.6 pre-initialization begin.");
        ModUtil.preInitTasks();
        proxy.preInit();
        AdventOfAscension.registerEvents();
        AdventOfAscension.registerCapabilities();
        PacketUtil.init();
        LootSystemRegister.registerCustomObjects();
        DimensionRegister.preInit();
        AdvancementTriggerRegister.registerTriggers();
        ThirdPartyInteractions.preInit();
        AdventOfAscension.logOptionalMessage("AoA3 pre-initialization finished.");
    }

    @Mod.EventHandler
    public void fmlInit(FMLInitializationEvent init) {
        AdventOfAscension.logOptionalMessage("AoA3 initialization begin.");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGen(), (int)5000);
        RecipeRegister.registerRecipes();
        BlockRegister.doInitTasks();
        ItemRegister.doInitTasks();
        StructuresHandler.registerStructures();
        BiomeRegister.init();
        EntitySpawnRegister.registerEntitySpawns();
        ThirdPartyInteractions.init();
        BannerUtil.init();
        AdventOfAscension.logOptionalMessage("AoA3 initialization finished.");
    }

    @Mod.EventHandler
    public void fmlPostInit(FMLPostInitializationEvent init) {
        AdventOfAscension.logOptionalMessage("AoA3 post-initialization begin.");
        proxy.postInit();
        WebUtil.doHTTPTasks();
        ModUtil.scrapeRegistries();
        this.authenticate();
        if (ConfigurationUtil.MainConfig.doVerboseDebugging) {
            ConfigurationUtil.doDebuggingPrintout(logger);
            ModUtil.doDebuggingPrintout(logger);
        }
        AdventOfAscension.logOptionalMessage("AoA3 post-initialization finished.");
    }

    @Mod.EventHandler
    public void fmlServerStarting(FMLServerStartingEvent event) {
        proxy.serverStart(event.getServer());
        event.registerServerCommand((ICommand)new CommandAoAStructure());
        event.registerServerCommand((ICommand)new CommandTslat());
        event.registerServerCommand((ICommand)new CommandAoAEvent());
        event.registerServerCommand((ICommand)new CommandAoASkill());
        event.registerServerCommand((ICommand)new CommandAoAPortalReset());
        event.registerServerCommand((ICommand)new CommandAoAWiki());
    }

    @Mod.EventHandler
    public void fmlServerStarted(FMLServerStartedEvent event) {
        proxy.serverStarted();
        this.authenticate();
        AdventOfAscension.registerGameRules();
    }

    @Mod.EventHandler
    public void fmlServerStopping(FMLServerStoppingEvent event) {
        ModUtil.serverShutdownTasks();
        proxy.serverShutdown();
    }

    @Mod.EventHandler
    public void fmlModComms(FMLInterModComms.IMCEvent event) {
        ThirdPartyInteractions.handleInterModComms((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    @Mod.EventHandler
    public void fingerprintViolation(FMLFingerprintViolationEvent ev) {
        if (!ev.isDirectory()) {
            logger.log(Level.WARN, ev.getSource().getName() + " appears to have been modified. Why do you do this? No support will be given for this jar. No Exceptions.");
        }
    }

    public static AdventOfAscension instance() {
        return instance;
    }

    private static void registerEvents() {
        EventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.register((Object)new GlobalEvents());
        AdventOfAscension.instance().playerEvents = new PlayerEvents();
        forgeBus.register((Object)AdventOfAscension.instance().playerEvents);
        forgeBus.register((Object)new CapabilitiesManager());
        forgeBus.register((Object)new EntityEvents());
        forgeBus.register((Object)new LootSystemRegister());
        forgeBus.register((Object)new WorldEvents());
    }

    private static void registerGameRules() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        for (DimensionType dimType : DimensionManager.getRegisteredDimensions().keySet()) {
            WorldServer world = server.func_71218_a(dimType.func_186068_a());
            if (world == null) continue;
            world.func_82736_K().func_180262_a("destructiveWeaponPhysics", "false", GameRules.ValueType.BOOLEAN_VALUE);
            world.func_82736_K().func_180262_a("doStrongerMobGriefing", "false", GameRules.ValueType.BOOLEAN_VALUE);
        }
    }

    private static void registerCapabilities() {
        CapabilityManager.INSTANCE.register(CapabilityBasePlayer.class, (Capability.IStorage)new AdventPlayerStorage(), AdventPlayerCapability::new);
        CapabilityManager.INSTANCE.register(CapabilityBaseMiscStack.class, (Capability.IStorage)new AdventMiscStackStorage(), AdventMiscStackCapability::new);
        CapabilityManager.INSTANCE.register(CapabilityBaseMiscStackSerializable.class, (Capability.IStorage)new AdventMiscStackSerializableStorage(), AdventMiscStackSerializeableCapability::new);
    }

    public static void logMessage(Level level, String message) {
        logger.log(level, message);
    }

    public static void logMessage(Level level, String message, Exception ex) {
        logger.log(level, message, (Throwable)ex);
    }

    public static void logOptionalMessage(String message, Exception ex) {
        if (ConfigurationUtil.MainConfig.doVerboseDebugging) {
            AdventOfAscension.logMessage(Level.INFO, message, ex);
        }
    }

    public static void logOptionalMessage(String message) {
        if (ConfigurationUtil.MainConfig.doVerboseDebugging) {
            AdventOfAscension.logMessage(Level.INFO, message);
        }
    }

    private void authenticate() {
        if (!this.UUIDTslat.equals(UUID.fromString("2459b511-ca45-43d8-808d-f0eb30a63be4")) || !this.UUIDUrsun.equals(UUID.fromString("69144818-2721-420d-ba56-3ec2b6176ae1"))) {
            AdventOfAscension.logMessage(Level.FATAL, "Someone is messing with things they shouldn't be messing with. I'm turning off now.");
            MinecraftForge.EVENT_BUS.unregister((Object)this.playerEvents);
        }
    }

    public final boolean isTslat(UUID uuid) {
        return uuid.equals(this.UUIDTslat);
    }

    public final boolean isUrsun(UUID uuid) {
        return uuid.equals(this.UUIDUrsun);
    }

    public Holiday getCurrentHoliday() {
        LocalDate date = LocalDate.now();
        if (date.compareTo(LocalDate.of(date.getYear(), Month.APRIL, 1)) == 0) {
            return Holiday.APRIL_FOOLS;
        }
        if (date.compareTo(LocalDate.of(date.getYear(), Month.DECEMBER, 25)) == 0) {
            return Holiday.CHRISTMAS;
        }
        if (date.compareTo(LocalDate.of(date.getYear(), Month.OCTOBER, 31)) == 0) {
            return Holiday.HALLOWEEN;
        }
        return Holiday.NONE;
    }

    static {
        logger = LogManager.getLogger((String)"aoa3");
        rand = new Random();
    }

    public static enum Holiday {
        NONE,
        CHRISTMAS,
        HALLOWEEN,
        APRIL_FOOLS;

    }
}

